package w83b.w83bOperacionesPaso.w83bBandejaEntrada;

import java.io.InputStream;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bFichaPreavisosAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bFichaPreavisos.xls";
		InputStream inputStream = W83bFichaPreavisosAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
		W83bPreavisosBean preaviso=(W83bPreavisosBean)contexto.get("w83bPreavisosAntiguoBean");
		//W83bPreavisosBean preaviso2=(W83bPreavisosBean)contexto.get("w83bPreavisosBeanSalida");
		//W83bPreavisosBean preaviso2=(W83bPreavisosBean)contexto.get("w83bPreavisosAntiguoBean");
		
		
       
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());      
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));
        HSSFHeader header = sheet.getHeader();//NOPMD
        header.setRight(W83bDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
        
        HSSFFooter footer = sheet.getFooter();//NOPMD

        footer.setCenter(((W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada());
        footer.setRight(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{footer.page()}));//NOPMD
      
        HSSFRow row ; 
        HSSFCell cell;
        ////
        row = sheet.getRow((short)3); 
        cell = row.getCell((short)2);
        StringBuffer tituloImagenEs = new StringBuffer();
        StringBuffer tituloImagenEu = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)4); 
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)2);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)4); 
        cell.setCellValue(tituloImagenEs.toString());
        
        
        row = sheet.getRow((short)8); // Creacin de la fila 1
        cell = row.getCell((short)1);

        
        //Titulo
        row = sheet.getRow((short)8); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.ficha",idioma));

        //Datos del preaviso
        row = sheet.getRow((short)10); 
        cell = row.getCell((short)1); 

        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.datosbasicos",idioma));
        
        //fin Datos del preaviso
        row = sheet.getRow((short)11); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numpreaviso",idioma)
        		+":  "+preaviso.getCodTerritorio()+"/"+preaviso.getAnyoPreaviso()+"/"+preaviso.getNumPreaviso());
        
     
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentrada",idioma)
        		+":  "+preaviso.getFecha_entrada());
        
       
        cell = row.getCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechinicio",idioma)
        		+":  "+preaviso.getFecha_inicio());
          
        row = sheet.getRow((short)13); 
        cell = row.getCell((short)1); 
        String valor=null;
        if("S".equals(preaviso.getS_parcial_008()))
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
        }
        else
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();
        }
        String valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.eleccionparcial",idioma)+":  "+valor);//NOPMD

        cell = row.getCell((short)4); 
        if("S".equals(preaviso.getPreaviso_global()))
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }
        else
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);
        }
        valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.prevglobal",idioma)+":  "+valor);//NOPMD
        
        row = sheet.getRow((short)14); 
        cell = row.getCell((short)1); 
        String numPreaviso = preaviso.getNum_registro();
        if(StringUtils.isEmpty(numPreaviso)){
        	numPreaviso = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numregistroes",idioma)+":  "+numPreaviso.toUpperCase());//NOPMD
        
        row = sheet.getRow((short)14); 
        cell = row.getCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechregistroes",idioma)+":  "+preaviso.getFecha_registro());//NOPMD
       /* 
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fecheleccion",idioma)+":  "+preaviso.getFecha_eleccion());//NOPMD
        
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)4);
        String nActa = "";
        if(StringUtils.isNotEmpty(preaviso.getCodterrit_acta())
        		&&StringUtils.isNotEmpty(preaviso.getAnyo_acta())
        		&&StringUtils.isNotEmpty(preaviso.getNum_acta())){
        	nActa = preaviso.getCodterrit_acta()+"/"+preaviso.getAnyo_acta()+"/"+preaviso.getNum_acta();//NOPMD
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",idioma)
        		+":  "+nActa);
        */
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)1); 
        if("A".equals(preaviso.getAdmon()))
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }
        else
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);
        }
        valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.admon",idioma)
        		+":  "+valor);
        
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)4); 
        if("E".equals(preaviso.getAdmonemp_008()))
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }
        else
        {
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);
        }
        valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.empresa",idioma)+":  "+valor);//NOPMD
        
        
        row = sheet.getRow((short)16); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.centrosafectados",idioma)
        		+":  "+preaviso.getN_cenafec_008());
        
       
        cell = row.getCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","documento.detalle.IdentificadorInterno",idioma)
        		+":  "+preaviso.getIdent_008());
          
        
        
        row = sheet.getRow((short)17); 
        cell = row.getCell((short)1); 
        if("es".equals(idioma)){
        	valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getDescConvenioCas());//NOPMD
        }else{
        	valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getDescConvenioEus());//NOPMD
        }
        String codConvenio = preaviso.getC_conv_008();
        if(StringUtils.isEmpty(codConvenio)){
        	codConvenio = "";
        }
        if(StringUtils.isEmpty(valor)){
        	valor = "";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.convenio",idioma)
        		+":  "+codConvenio+"-"+valor);
        int tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        row = sheet.getRow((short)18); 
        cell = row.getCell((short)1);
        String observaciones = preaviso.getObservaciones();
        if(StringUtils.isEmpty(observaciones)){
        	observaciones = "";
        }
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(observaciones);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.observaciones",idioma)
        		+":  "+valor);
        tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }                 
        HSSFRow rowTemp = sheet.getRow((short)10);
        row = sheet.createRow((short)20); 
        cell = row.createCell((short)1);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.promotoreselec",idioma));
        cell = row.createCell((short)2); 
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        int numlinea=20;

        if (StringUtils.isNotEmpty(preaviso.getC_sindi_prom_008()))
        {
        	 rowTemp = sheet.getRow((short)18);
        	row = sheet.createRow((short)++numlinea);
        	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("5")));//NOPMD
        	 cell = row.createCell((short)1); 
             valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getDescSindi());
             cell.setCellValue(preaviso.getC_sindi_prom_008() + "-" + valor);
             cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
             cell = row.createCell((short)5); 
             cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        	
        	/*
        	 String [] descPromotores=preaviso.getPromotores_desc().split("\\?");
             String [] desc=null;
             rowTemp = sheet.getRow((short)18);
             for (int i=0;i<descPromotores.length;i++)
             {
             	desc=descPromotores[i].split("@");
             	row = sheet.createRow((short)++numlinea); 
             	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("5")));//NOPMD
                 cell = row.createCell((short)1); 
                 valor = W83bUtilidadesExcel.mayusculasCampoExcel(desc[0]);
                 cell.setCellValue(desc[1] + "-" + valor);
                 cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
                 cell = row.createCell((short)5); 
                 cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
                 
             }
             */
             rowTemp = sheet.getRow((short)18);
             cell = row.getCell((short)1); 
             cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
             cell = row.createCell((short)2); 
             cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
             cell = row.createCell((short)3); 
             cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());             
             cell = row.createCell((short)4); 
             cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());             
             ++numlinea;
             tamanyoTexto = cell.getStringCellValue().length();
             if(93<tamanyoTexto){
             	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
             }
        }
       
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.datos_empresa",idioma));
        rowTemp = sheet.getRow((short)10);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)2); 
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());

        rowTemp = sheet.getRow((short)11);
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.cif",idioma)
        		+":  "+preaviso.getCifpreaviso());
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
       
      /*  row = sheet.createRow((short)numlinea); 
        cell = row.createCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",idioma)
        		+":  "+preaviso.getCentroTrabajo().getNumCentro());
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        */
        
        row = sheet.createRow((short)++numlinea); 
        sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("4")));
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getRazonSocialPreaviso());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     	tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        row = sheet.createRow((short)++numlinea); 
        sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("4")));
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getDomic_008());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.domicilioTrabajo",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     	tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.codPostal",idioma)
        		+":  "+preaviso.getCodpos_008());
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
       /* row = sheet.createRow((short)numlinea); 
        cell = row.createCell((short)4); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getCentroTrabajo().getLocalidad());
        if(StringUtils.isEmpty(valor)){
        	valor="";
        }
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.localidad",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        */
       
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getDescmunicipio());
       
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.municipio",idioma)
        		+":  ");
       
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)2); 
        cell.setCellValue(valor);
        int tamanyo = cell.getStringCellValue().length();
        
        if(17<tamanyo){
        	row.setHeightInPoints((short)(25*(tamanyo/17)+1));
        }
        
       // cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
      //  HSSFCellStyle estilo =  rowTemp.getCell((short)2).getCellStyle();
      //  estilo.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY);
      //  cell.setCellStyle(estilo);
       
      //  cell = row.createCell((short)3); 
      //  cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        
        row = sheet.getRow((short)numlinea); 
        cell = row.createCell((short)4); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getDescprovincia());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.provincia",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getCnae_008());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.cnae",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
       
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getTelefono_008());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.telefono",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        //cell = row.createCell((short)2); 
        //cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        
        row = sheet.getRow((short)numlinea); 
        cell = row.createCell((short)4); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getFax_008());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.fax",idioma)
        		+":  "+valor);
        //cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        rowTemp = sheet.getRow((short)18);
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(preaviso.getEmail_008());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.usuarios.email",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)2); 
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        ++numlinea;
      
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=fichaPreavisos.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}

}

